<?php // BEGIN PHP
$websitekey=basename(__DIR__); if (empty($websitepagefile)) $websitepagefile=__FILE__;
if (! defined('USEDOLIBARRSERVER') && ! defined('USEDOLIBARREDITOR')) {
	$pathdepth = count(explode('/', $_SERVER['SCRIPT_NAME'])) - 2;
	require_once ($pathdepth ? str_repeat('../', $pathdepth) : './').'master.inc.php';
} // Not already loaded
require_once DOL_DOCUMENT_ROOT.'/core/lib/website.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/website.inc.php';
ob_start();
// END PHP ?>
<html lang="en">
<head>
<title>Careers</title>
<meta charset="utf-8">
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<meta name="robots" content="index, follow" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="keywords" content="career" />
<meta name="title" content="Careers" />
<meta name="description" content="Our job opportunities" />
<meta name="generator" content="Dolibarr 14.0.0-alpha (https://www.dolibarr.org)" />
<meta name="dolibarr:pageid" content="4" />
<?php if ($website->use_manifest) { print '<link rel="manifest" href="/manifest.json.php" />'."\n"; } ?>
<!-- Include link to CSS file -->
<link rel="stylesheet" href="/styles.css.php?website=<?php echo $websitekey; ?>" type="text/css" />
<!-- Include link to JS file -->
<script src="/javascript.js.php"></script>
<!-- Include HTML header from common file -->
<?php if (file_exists(DOL_DATA_ROOT."/website/".$websitekey."/htmlheader.html")) include DOL_DATA_ROOT."/website/".$websitekey."/htmlheader.html"; ?>
<!-- Include HTML header from page header block -->

</head>
<!-- File generated by Dolibarr website module editor -->
<body id="bodywebsite" class="bodywebsite bodywebpage-careers">
<div class="page">

    <?php includeContainer('header'); ?>

      <section id="sectionimage" contenteditable="true">
        <div class="">
          <div class="swiper-wrapper text-center" style="transform: translate3d(0px, 0px, 0px); transition-duration: 0ms;">
            <div class="swiper-slide swiper-slide-active" style="height: 200px; background-image: url('medias/image/template-corporate/background_sunset.jpg'); background-size: cover;">
              <div class="swiper-slide-caption">
                <div class="container">
                  <div class="row justify-content-sm-center">
                    <div class="col-md-11 col-lg-10">
                      <div class="text-white text-uppercase jumbotron-custom border-modern fadeInUp animated" data-caption-animate="fadeInUp" data-caption-delay="0s">Job opportunities</span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
        </div>
      </section>


        <section id="sectionfooterdolibarr" contenteditable="true" class="footerdolibarr">
            <div style="margin: 50px"><div class="text-align: center">
            <br>

            <h2 style="margin-left: 10px; margin-right: 10px">We are recruiting the following profiles...</h2><br><br> 
            
            <section id="sectionnews" contenteditable="false" class="section-50 section-md-50 section-md-bottom-50">
            <?php
            include_once DOL_DOCUMENT_ROOT.'/recruitment/class/recruitmentjobposition.class.php';
            $jobposition = new RecruitmentJobPosition($db);
            $fuser = new User($db);
            $arrayofrecord = $jobposition->fetchAll('DESC', 'date_creation', 5, 0, array('status'=>'1,3,9'));
            $weblangs->load("main");
            foreach($arrayofrecord as $jobrecord)
            {
                print '<div class="row justify-content-sm-center row-40">';
                print '<div class="container blog-box d-xl-inline-block" style="box-shadow: -1px 0px 10px 0px rgba(65, 65, 65, 0.12); transition: .3s all ease;">';
                            //print '<a href="/public/recruitment/view.php?id='.$jobrecord->id.'.php">';
                            //print '<div class="post-boxed-img-wrap"><img src="'.($blog->image ? 'viewimage.php?modulepart=medias&file='.$blog->image : 'medias/image/'.$website->ref.'/calendar.svg"').'" alt="" width="120"></div>';
                            print '<div class="post-boxed-caption">';
                            print '<div class="post-boxed-title font-weight-bold">'.$jobrecord->label.'</div>';
                            print '<ul class="list-inline list-inline-dashed">';
                            print '<li><span class="text-primary">'.dol_print_date($jobrecord->date_creation, 'daytext', 'tzserver', $weblangs).'</span></li>';
                            //$fuser->fetch($jobrecord->fk_user_recruitment);
                            //print '<li><span>par<span> <span class="text-primary">'.$fuser->firstname.'</span></span></li>';
                            //print '<li><span>Contact:<span> <span class="text-primary">Laurent Destailleur - job@nltechno.com</span></span></li>';
                            print '</ul>';
                            print '</div>';

                            print '<div class="left" style="line-height: 1.5em; margin-top: 30px; margin-left: 20px; margin-right: 20px">';
                            //includeContainer($blog->pageurl);
                            
                            if ($jobrecord->status == RecruitmentJobPosition::STATUS_RECRUITED) {
                                $langs->load('recruitment');
                            	print info_admin($langs->trans("JobClosedTextCandidateFound"), 0, 0, 0, 'warning');
                            	print '<br>';
                            }
                            if ($jobrecord->status == RecruitmentJobPosition::STATUS_CANCELED) {
                                $langs->load('recruitment');
	                            print info_admin($langs->trans("JobClosedTextCanceled"), 0, 0, 0, 'warning');
	                            print '<br>';
                            }


                            print '<span class="nohover">'.$jobrecord->description.'</span>';
                            
                            print '<br><br><span>Contact:<span> <span class="text-primary">Laurent Destailleur - '.$jobrecord->email_recruiter.'</span></span>';
                            
                            print '</div>';
                            //print '</a>';
                print '</div>';
                print '</div>';
            }
            ?>
            </section>
            </div></div>
        </section>


    <br><br>

    <?php includeContainer('footer'); ?>

</div>
    


</body>
</html>
<?php // BEGIN PHP
$tmp = ob_get_contents(); ob_end_clean(); dolWebsiteOutput($tmp, "html", 4);
// END PHP ?>
